import javax.media.j3d.*;
import com.sun.j3d.utils.picking.*;
import com.sun.j3d.utils.picking.behaviors.*;
import com.sun.j3d.utils.geometry.*;
/**
 * This class implements a simple pick behaviour.
 * It prints out a message identifying which object has been picked
 * by using the userData of the object.  The use of this class is
 * demonstrated in SimplePick.
 * @author I.J.Palmer
 * @version 1.0
 * @see SimplePick
 */
public class SimplePickBehaviour extends PickMouseBehavior {
    /**
      * @param pickRoot BranchGroup that is the root of the picking operation.
      * @param pickCanvas Canvas3D used in the pick operation.
      * @param pickBounds Bounds that define the behaviour's active region.
       */
      public SimplePickBehaviour(Canvas3D theCanvas, BranchGroup pickRoot, 
			       Bounds pickBounds) {
            super(theCanvas, pickRoot, pickBounds);
            setSchedulingBounds(pickBounds);
            pickCanvas.setMode(PickTool.BOUNDS);
      }
	/**
	 * Where the processing is carried out.
	 * This checks if an object has been picked and if it
	 * has prints out the user data for that shape.
	 * @xpos int that stores the x-position of the mouse
	 * @ypos int that stores the y-position of the mouse
	 */
	public void updateScene(int xpos, int ypos) {
                                PickResult pickResult = null;
		Primitive pickedShape = null;
		pickCanvas.setShapeLocation(xpos,ypos);

		pickResult = pickCanvas.pickClosest();
		 if (pickResult != null)
		     pickedShape = (Primitive) pickResult.getNode(PickResult.PRIMITIVE);
		 if (pickedShape != null)
			System.out.println("Picked the " + pickedShape.getUserData());
		else
			System.out.println("Picked nothing");
    	}
}
